﻿/* Skripte zur Fallunterscheidung
 * Auszufuehren als Benutzer SCOTT
 */
-- einfache CASE-Anweisung
select ename, job,
       case job
	     when 'MANAGER' then sal * 1.02
		 when 'ANALYST' then sal * 1.03
		 when 'SALESMAN' then sal + 50
		 when 'CLERK' then sal + 80
		 else sal end as new_sal
  from emp;
  
-- geschachtelte CASE-Anweisung
select ename, job,
       case job
	     when 'MANAGER' then
		   case deptno
		     when 10 then sal * 1.01
			 when 20 then sal * 1.02
			 when 30 then sal * 1.04
			 else sal 
		   end
		 when 'CLERK' then sal + 80
		 else sal end as new_sal
  from emp;
  
-- Auswertende CASE-Anweisung
select ename, job,
       case
	     when job = 'MANAGER' and sal < 2900 then sal * 1.03
		 when job = 'MANAGER' then sal * 1.02
		 when job like 'SALES%' then sal + 120
		 when deptno = 20 then sal + 25
		 else sal
	   end as new_sal
  from emp;
  
-- Verwendung der DECODE-Anweisung
select ename, job,
       decode(job,
              'MANAGER', sal * 1.02,
              'ANALYST', sal * 1.03,
              'SALESMAN', sal + 50,
              'CLERK', sal + 80,
              sal) as new_sal
  from emp;
  
-- Die DECODE-Anweisung und NULL-Werte
-- Das geht nicht: Prüfung auf NULL in einer einfache CASE-Anweisung
select ename, mgr,
       decode(mgr,
         null, 'Kein Manager',
         'hat Manager')
  from emp;
  
-- ... wohl aber mit der DECODE-Anweisung:
select ename, mgr,
       case mgr
       when null then 'Kein Manager'
       else 'hat Manager' end
  from emp;